/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.create;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.TableInfo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.create.PopulateMetadata;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChooseDir
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final TableInfo tableInfo;
    private static final Logger log = LoggerFactory.getLogger(ChooseDir.class);

    ChooseDir(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        if (this.tableInfo.getInitialSplitSize() > 0) {
            this.createTableDirectoriesInfo(manager);
        }
        return new PopulateMetadata(this.tableInfo);
    }

    @Override
    public void undo(long tid, Manager manager) throws Exception {
        Path p = null;
        try {
            if (this.tableInfo.getInitialSplitSize() > 0) {
                p = this.tableInfo.getSplitDirsPath();
                FileSystem fs = p.getFileSystem(manager.getContext().getHadoopConf());
                fs.delete(p, true);
            }
        }
        catch (IOException e) {
            log.error("Failed to undo ChooseDir operation and failed to clean up split files at {}", p, (Object)e);
        }
    }

    private void createTableDirectoriesInfo(Manager manager) throws IOException {
        SortedSet<Text> splits = Utils.getSortedSetFromFile(manager, this.tableInfo.getSplitPath(), true);
        SortedSet<Text> tabletDirectoryInfo = ChooseDir.createTabletDirectoriesSet(manager, splits.size());
        this.writeTabletDirectoriesToFileSystem(manager, tabletDirectoryInfo);
    }

    private static SortedSet<Text> createTabletDirectoriesSet(Manager manager, int num) {
        UniqueNameAllocator namer = manager.getContext().getUniqueNameAllocator();
        TreeSet<Text> splitDirs = new TreeSet<Text>();
        for (int i = 0; i < num; ++i) {
            String tabletDir = "t-" + namer.getNextName();
            splitDirs.add(new Text(tabletDir));
        }
        return splitDirs;
    }

    private void writeTabletDirectoriesToFileSystem(Manager manager, SortedSet<Text> dirs) throws IOException {
        Path p = this.tableInfo.getSplitDirsPath();
        FileSystem fs = p.getFileSystem(manager.getContext().getHadoopConf());
        if (fs.exists(p)) {
            fs.delete(p, true);
        }
        try (FSDataOutputStream stream = fs.create(p);){
            for (Text dir : dirs) {
                stream.write((String.valueOf(dir) + "\n").getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

