/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.bulkVer2;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.bulk.Bulk;
import org.apache.accumulo.core.clientImpl.bulk.BulkSerialize;
import org.apache.accumulo.core.clientImpl.bulk.LoadMappingIterator;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.MapFileInfo;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.util.Timer;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.bulkVer2.BulkInfo;
import org.apache.accumulo.manager.tableOps.bulkVer2.CleanUpBulkImport;
import org.apache.accumulo.manager.tableOps.bulkVer2.CompleteBulkImport;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoadFiles
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LoadFiles.class);
    private final BulkInfo bulkInfo;
    private static final Comparator<Text> PREV_COMP = Comparator.nullsFirst(BinaryComparable::compareTo);
    private static final Comparator<Text> END_COMP = Comparator.nullsLast(BinaryComparable::compareTo);

    public LoadFiles(BulkInfo bulkInfo) {
        this.bulkInfo = bulkInfo;
    }

    @Override
    public long isReady(long tid, Manager manager) throws Exception {
        log.info("Starting for {} (tid = {})", (Object)this.bulkInfo.sourceDir, (Object)FateTxId.formatTid((long)tid));
        if (manager.onlineTabletServers().isEmpty()) {
            log.warn("There are no tablet server to process bulkDir import, waiting (tid = " + FateTxId.formatTid((long)tid) + ")");
            return 100L;
        }
        VolumeManager fs = manager.getVolumeManager();
        Path bulkDir = new Path(this.bulkInfo.bulkDir);
        manager.updateBulkImportStatus(this.bulkInfo.sourceDir, BulkImportState.LOADING);
        try (LoadMappingIterator lmi = BulkSerialize.getUpdatedLoadMapping((String)bulkDir.toString(), (TableId)this.bulkInfo.tableId, arg_0 -> ((VolumeManager)fs).open(arg_0));){
            long l;
            block13: {
                Loader loader = this.bulkInfo.tableState == TableState.ONLINE ? new OnlineLoader(manager.getConfiguration()) : new OfflineLoader();
                try {
                    TabletsMetadataFactory tmf = startRow -> TabletsMetadata.builder((AccumuloClient)manager.getContext()).forTable(this.bulkInfo.tableId).overlapping(startRow, null).checkConsistency().fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.PREV_ROW, TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.LOADED}).build();
                    int skip = manager.getContext().getTableConfiguration(this.bulkInfo.tableId).getCount(Property.TABLE_BULK_SKIP_THRESHOLD);
                    l = LoadFiles.loadFiles(loader, this.bulkInfo, bulkDir, lmi, tmf, manager, tid, skip);
                    if (loader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (loader != null) {
                        try {
                            loader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                loader.close();
            }
            return l;
        }
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) {
        if (this.bulkInfo.tableState == TableState.ONLINE) {
            return new CompleteBulkImport(this.bulkInfo);
        }
        return new CleanUpBulkImport(this.bulkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long loadFiles(Loader loader, BulkInfo bulkInfo, Path bulkDir, LoadMappingIterator loadMapIter, TabletsMetadataFactory factory, Manager manager, long tid, int skipDistance) throws Exception {
        long sleepTime;
        PeekingIterator lmi = new PeekingIterator((Iterator)loadMapIter);
        Map.Entry loadMapEntry = (Map.Entry)lmi.peek();
        Text startRow = ((KeyExtent)loadMapEntry.getKey()).prevEndRow();
        String fmtTid = FateTxId.formatTid((long)tid);
        log.trace("{}: Started loading files at row: {}", (Object)fmtTid, (Object)startRow);
        loader.start(bulkDir, manager, tid, bulkInfo.setTime);
        ImportTimingStats importTimingStats = new ImportTimingStats();
        Timer timer = Timer.startNew();
        try (TabletsMetadata tabletsMetadata = factory.newTabletsMetadata(startRow);){
            PeekingIterator pi = new PeekingIterator(tabletsMetadata.iterator());
            while (lmi.hasNext()) {
                KeyExtent loadMapKey;
                loadMapEntry = (Map.Entry)lmi.next();
                if (skipDistance > 0 && !pi.findWithin(arg_0 -> LoadFiles.lambda$loadFiles$1(loadMapKey = (KeyExtent)loadMapEntry.getKey(), arg_0), skipDistance)) {
                    log.debug("{}: Next load mapping range {} not found in {} tablets, recreating TabletMetadata to jump ahead", new Object[]{fmtTid, loadMapKey.prevEndRow(), skipDistance});
                    tabletsMetadata.close();
                    tabletsMetadata = factory.newTabletsMetadata(loadMapKey.prevEndRow());
                    pi = new PeekingIterator(tabletsMetadata.iterator());
                }
                List<TabletMetadata> tablets = LoadFiles.findOverlappingTablets(fmtTid, (KeyExtent)loadMapEntry.getKey(), (Iterator<TabletMetadata>)pi, importTimingStats);
                loader.load(tablets, (Bulk.Files)loadMapEntry.getValue());
            }
        }
        Duration totalProcessingTime = timer.elapsed();
        log.trace("{}: Completed Finding Overlapping Tablets", (Object)fmtTid);
        if (importTimingStats.callCount > 0L) {
            log.debug("Stats for {} (tid = {}): processed {} tablets in {} calls which took {}ms ({} nanos). Skipped {} iterations which took {}ms ({} nanos) or {}% of the processing time.", new Object[]{bulkInfo.sourceDir, FateTxId.formatTid((long)tid), importTimingStats.tabletCount, importTimingStats.callCount, totalProcessingTime.toMillis(), totalProcessingTime.toNanos(), importTimingStats.wastedIterations, importTimingStats.totalWastedTime.toMillis(), importTimingStats.totalWastedTime.toNanos(), importTimingStats.totalWastedTime.toNanos() * 100L / totalProcessingTime.toNanos()});
        }
        if ((sleepTime = loader.finish()) > 1L) {
            log.trace("{}: Tablet Max Sleep is {}", (Object)fmtTid, (Object)sleepTime);
            long scanTime = Math.min(totalProcessingTime.toMillis(), 30000L);
            log.trace("{}: Scan time is {}", (Object)fmtTid, (Object)scanTime);
            sleepTime = Math.max(sleepTime, scanTime * 2L);
        }
        log.trace("{}: Sleeping for {}ms", (Object)fmtTid, (Object)sleepTime);
        return sleepTime;
    }

    static List<TabletMetadata> findOverlappingTablets(String fmtTid, KeyExtent loadRange, Iterator<TabletMetadata> tabletIter, ImportTimingStats importTimingStats) {
        TabletMetadata currTablet = null;
        try {
            int cmp;
            ArrayList<TabletMetadata> tablets = new ArrayList<TabletMetadata>();
            currTablet = tabletIter.next();
            log.trace("{}: Finding Overlapping Tablets for row: {}", (Object)fmtTid, (Object)currTablet.getExtent());
            long wastedIterations = 0L;
            Timer timer = Timer.startNew();
            while ((cmp = PREV_COMP.compare(currTablet.getPrevEndRow(), loadRange.prevEndRow())) < 0) {
                ++wastedIterations;
                log.trace("{}: Skipping tablet: {}", (Object)fmtTid, (Object)currTablet.getExtent());
                currTablet = tabletIter.next();
            }
            Duration wastedTime = timer.elapsed();
            if (cmp != 0) {
                throw new IllegalStateException("Unexpected prev end row " + String.valueOf(currTablet.getExtent()) + " " + String.valueOf(loadRange));
            }
            log.trace("{}: Adding tablet: {} to overlapping list", (Object)fmtTid, (Object)currTablet.getExtent());
            tablets.add(currTablet);
            while ((cmp = END_COMP.compare(currTablet.getEndRow(), loadRange.endRow())) < 0) {
                currTablet = tabletIter.next();
                log.trace("{}: Adding tablet: {} to overlapping list", (Object)fmtTid, (Object)currTablet.getExtent());
                tablets.add(currTablet);
            }
            if (cmp != 0) {
                throw new IllegalStateException("Unexpected end row " + String.valueOf(currTablet) + " " + String.valueOf(loadRange));
            }
            importTimingStats.wastedIterations += wastedIterations;
            importTimingStats.totalWastedTime = importTimingStats.totalWastedTime.plus(wastedTime);
            importTimingStats.tabletCount += (long)tablets.size();
            ++importTimingStats.callCount;
            return tablets;
        }
        catch (NoSuchElementException e) {
            NoSuchElementException ne2 = new NoSuchElementException("Failed to find overlapping tablets " + String.valueOf(currTablet) + " " + String.valueOf(loadRange));
            ne2.initCause(e);
            throw ne2;
        }
    }

    private static /* synthetic */ boolean lambda$loadFiles$1(KeyExtent loadMapKey, TabletMetadata tm) {
        return PREV_COMP.compare(tm.getPrevEndRow(), loadMapKey.prevEndRow()) >= 0;
    }

    static class OnlineLoader
    extends Loader {
        private final int maxConnections;
        long timeInMillis;
        String fmtTid;
        int locationLess = 0;
        int tabletsAdded;
        private ExecutorService rpcExecutor;
        private CompletableFuture<Void> prevRpcTask;
        Map<HostAndPort, Map<TKeyExtent, Map<String, MapFileInfo>>> loadQueue;
        private int queuedDataSize = 0;
        final AtomicReference<Map<HostAndPort, Map<TKeyExtent, Map<String, MapFileInfo>>>> backgroundQueue = new AtomicReference();

        public OnlineLoader(AccumuloConfiguration configuration) {
            this.maxConnections = configuration.getCount(Property.MANAGER_BULK_MAX_CONNECTIONS);
        }

        @Override
        void start(Path bulkDir, Manager manager, long tid, boolean setTime) throws Exception {
            super.start(bulkDir, manager, tid, setTime);
            this.timeInMillis = manager.getConfiguration().getTimeInMillis(Property.MANAGER_BULK_TIMEOUT);
            this.fmtTid = FateTxId.formatTid((long)tid);
            this.tabletsAdded = 0;
            this.loadQueue = new HashMap<HostAndPort, Map<TKeyExtent, Map<String, MapFileInfo>>>();
            this.rpcExecutor = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.ACCUMULO_POOL_PREFIX.poolName + "bulk.rpc." + this.fmtTid).numCoreThreads(1).numMaxThreads(1).enableThreadPoolMetrics(false).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendBackground() {
            ArrayList clients;
            Map<HostAndPort, Map<TKeyExtent, Map<String, MapFileInfo>>> queue;
            block9: {
                queue = this.backgroundQueue.get();
                clients = new ArrayList();
                try {
                    Timer sendTimer = Timer.startNew();
                    queue.forEach((server, tabletFiles) -> {
                        if (log.isTraceEnabled()) {
                            log.trace("{} asking {} to bulk import {} files for {} tablets", new Object[]{this.fmtTid, server, tabletFiles.values().stream().mapToInt(Map::size).sum(), tabletFiles.size()});
                        }
                        int neededConnections = Math.min(this.maxConnections, tabletFiles.size());
                        if (log.isTraceEnabled() && tabletFiles.size() > this.maxConnections) {
                            log.trace("{} Hitting max connection limit set by property {} for {}. Desired connection count {}", new Object[]{this.fmtTid, Property.MANAGER_BULK_MAX_CONNECTIONS.getKey(), server, tabletFiles.size()});
                        }
                        ArrayList chunks = new ArrayList(neededConnections);
                        for (int i = 0; i < neededConnections; ++i) {
                            chunks.add(new HashMap());
                        }
                        int nextConnection = 0;
                        for (Map.Entry entry : tabletFiles.entrySet()) {
                            ((Map)chunks.get(nextConnection++ % chunks.size())).put((TKeyExtent)entry.getKey(), (Map)entry.getValue());
                        }
                        for (Map map : chunks) {
                            try {
                                TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)server, (ClientContext)this.manager.getContext(), (long)this.timeInMillis);
                                clients.add(new Client((HostAndPort)server, client));
                                client.send_loadFilesV2(TraceUtil.traceInfo(), this.manager.getContext().rpcCreds(), this.tid, this.bulkDir.toString(), map, this.setTime);
                            }
                            catch (TException ex) {
                                log.debug("rpc send failed server: {}, {}", new Object[]{server, this.fmtTid, ex});
                            }
                        }
                    });
                    long sendTime = sendTimer.elapsed(TimeUnit.MILLISECONDS);
                    sendTimer.restart();
                    int outdatedTservers = 0;
                    for (Client client : clients) {
                        try {
                            client.service.recv_loadFilesV2();
                        }
                        catch (TException ex) {
                            String additionalInfo = "";
                            if (ex instanceof TApplicationException && ((TApplicationException)ex).getType() == 1) {
                                ++outdatedTservers;
                                additionalInfo = " (tserver may be running older version)";
                            }
                            log.debug("rpc recv failed server{}: {}, {}", new Object[]{additionalInfo, client.server, this.fmtTid, ex});
                        }
                    }
                    if (outdatedTservers > 0) {
                        log.warn("{} can not proceed with bulk import because {} tablet servers are likely running an older version. Please update tablet servers to same patch level as manager.", (Object)this.fmtTid, (Object)outdatedTservers);
                    }
                    if (!log.isDebugEnabled()) break block9;
                    long recvTime = sendTimer.elapsed(TimeUnit.MILLISECONDS);
                    IntSummaryStatistics tabletStats = queue.values().stream().mapToInt(Map::size).summaryStatistics();
                    log.debug("{} sent {} messages to {} tablet servers for {} tablets (min:{} max:{} avg:{} tablets per tserver), send time:{}ms recv time:{}ms {}:{}", new Object[]{this.fmtTid, clients.size(), queue.size(), tabletStats.getSum(), tabletStats.getMin(), tabletStats.getMax(), tabletStats.getAverage(), sendTime, recvTime, Property.MANAGER_BULK_MAX_CONNECTIONS.getKey(), this.maxConnections});
                }
                catch (Throwable throwable) {
                    Preconditions.checkState((boolean)this.backgroundQueue.compareAndSet(queue, null));
                    for (Client client : clients) {
                        ThriftUtil.returnClient((TServiceClient)client.service, (ClientContext)this.manager.getContext());
                    }
                    throw throwable;
                }
            }
            Preconditions.checkState((boolean)this.backgroundQueue.compareAndSet(queue, null));
            for (Client client : clients) {
                ThriftUtil.returnClient((TServiceClient)client.service, (ClientContext)this.manager.getContext());
            }
        }

        private void sendQueued(int threshold) {
            if (this.queuedDataSize > threshold || threshold == 0) {
                if (this.prevRpcTask != null) {
                    this.prevRpcTask.join();
                }
                Preconditions.checkState((boolean)this.backgroundQueue.compareAndSet(null, this.loadQueue));
                this.prevRpcTask = CompletableFuture.runAsync(this::sendBackground, this.rpcExecutor);
                this.loadQueue = new HashMap<HostAndPort, Map<TKeyExtent, Map<String, MapFileInfo>>>();
                this.queuedDataSize = 0;
            }
            if (threshold == 0) {
                this.prevRpcTask.join();
                this.prevRpcTask = null;
            }
        }

        protected void addToQueue(HostAndPort server, KeyExtent extent, Map<String, MapFileInfo> thriftImports) {
            if (!thriftImports.isEmpty()) {
                ++this.tabletsAdded;
                Map<String, MapFileInfo> prev = this.loadQueue.computeIfAbsent(server, k -> new HashMap()).putIfAbsent(extent.toThrift(), thriftImports);
                Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Unexpectedly saw extent %s twice", (Object)extent);
                this.queuedDataSize += thriftImports.keySet().stream().mapToInt(String::length).sum() + server.getHost().length() + 4 + thriftImports.size() * 32;
            }
        }

        @Override
        void load(List<TabletMetadata> tablets, Bulk.Files files) {
            for (TabletMetadata tablet : tablets) {
                Set loadedFiles = tablet.getLoaded().keySet();
                TabletMetadata.Location location = tablet.getLocation();
                HashMap<String, MapFileInfo> thriftImports = new HashMap<String, MapFileInfo>();
                boolean needToLoad = false;
                for (Bulk.FileInfo fileInfo : files) {
                    Path fullPath = new Path(this.bulkDir, fileInfo.getFileName());
                    TabletFile bulkFile = new TabletFile(fullPath);
                    if (loadedFiles.contains(bulkFile)) continue;
                    if (location == null) {
                        needToLoad = true;
                        break;
                    }
                    thriftImports.put(fileInfo.getFileName(), new MapFileInfo(fileInfo.getEstFileSize()));
                }
                if (location != null) {
                    this.addToQueue(location.getHostAndPort(), tablet.getExtent(), thriftImports);
                    continue;
                }
                if (!needToLoad) continue;
                ++this.locationLess;
            }
            this.sendQueued(0x400000);
        }

        @Override
        long finish() {
            this.sendQueued(0);
            long sleepTime = 0L;
            if (this.tabletsAdded > 0) {
                sleepTime = 1L;
            }
            if (this.locationLess > 0) {
                sleepTime = Math.max(100L, (long)this.locationLess);
            }
            return sleepTime;
        }

        @Override
        public void close() {
            this.rpcExecutor.shutdownNow();
        }

        private static class Client {
            final HostAndPort server;
            final TabletClientService.Client service;

            private Client(HostAndPort server, TabletClientService.Client service) {
                this.server = server;
                this.service = service;
            }
        }
    }

    private static class OfflineLoader
    extends Loader {
        BatchWriter bw;
        MapCounter<HostAndPort> unloadingTablets;

        private OfflineLoader() {
        }

        @Override
        void start(Path bulkDir, Manager manager, long tid, boolean setTime) throws Exception {
            Preconditions.checkArgument((!setTime ? 1 : 0) != 0);
            super.start(bulkDir, manager, tid, setTime);
            this.bw = manager.getContext().createBatchWriter(MetadataTable.NAME);
            this.unloadingTablets = new MapCounter();
        }

        @Override
        void load(List<TabletMetadata> tablets, Bulk.Files files) throws MutationsRejectedException {
            byte[] fam = TextUtil.getBytes((Text)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            for (TabletMetadata tablet : tablets) {
                if (tablet.getLocation() != null) {
                    this.unloadingTablets.increment((Object)tablet.getLocation().getHostAndPort(), 1L);
                    continue;
                }
                Mutation mutation = new Mutation(tablet.getExtent().toMetaRow());
                for (Bulk.FileInfo fileInfo : files) {
                    String fullPath = new Path(this.bulkDir, fileInfo.getFileName()).toString();
                    byte[] val = new DataFileValue(fileInfo.getEstFileSize(), fileInfo.getEstNumEntries()).encode();
                    mutation.put(fam, fullPath.getBytes(StandardCharsets.UTF_8), val);
                }
                this.bw.addMutation(mutation);
            }
        }

        @Override
        long finish() throws Exception {
            this.bw.close();
            long sleepTime = 0L;
            if (this.unloadingTablets.size() > 0) {
                sleepTime = this.unloadingTablets.max() * 13L;
            }
            return sleepTime;
        }

        @Override
        public void close() {
        }
    }

    static interface TabletsMetadataFactory {
        public TabletsMetadata newTabletsMetadata(Text var1);
    }

    public static abstract class Loader
    implements AutoCloseable {
        protected Path bulkDir;
        protected Manager manager;
        protected long tid;
        protected boolean setTime;

        void start(Path bulkDir, Manager manager, long tid, boolean setTime) throws Exception {
            this.bulkDir = bulkDir;
            this.manager = manager;
            this.tid = tid;
            this.setTime = setTime;
        }

        abstract void load(List<TabletMetadata> var1, Bulk.Files var2) throws Exception;

        abstract long finish() throws Exception;
    }

    static class ImportTimingStats {
        Duration totalWastedTime = Duration.ZERO;
        long wastedIterations = 0L;
        long tabletCount = 0L;
        long callCount = 0L;

        ImportTimingStats() {
        }
    }
}

