/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.ActiveCompactionHelper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListCompactionsCommand
extends Shell.Command {
    private Option tserverOption;
    private Option disablePaginationOpt;
    private Option filterOption;

    @Override
    public String description() {
        return "lists what compactions are currently running in accumulo. See the accumulo.core.client.admin.ActiveCompaction javadoc for more information about columns.";
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String filterText = null;
        InstanceOperations instanceOps = shellState.getAccumuloClient().instanceOperations();
        boolean paginate = !cl.hasOption(this.disablePaginationOpt.getOpt());
        Stream<String> activeCompactionStream = cl.hasOption(this.tserverOption.getOpt()) ? ActiveCompactionHelper.activeCompactionsForServer(cl.getOptionValue(this.tserverOption.getOpt()), instanceOps) : ActiveCompactionHelper.activeCompactions(instanceOps);
        if (cl.hasOption(this.filterOption.getOpt())) {
            filterText = ".*" + cl.getOptionValue(this.filterOption.getOpt()) + ".*";
        }
        if (filterText != null) {
            activeCompactionStream = activeCompactionStream.filter(Pattern.compile(filterText).asMatchPredicate());
        }
        activeCompactionStream = ActiveCompactionHelper.appendHeader(activeCompactionStream);
        shellState.printLines(activeCompactionStream.iterator(), paginate);
        return 0;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        this.filterOption = new Option("f", "filter", true, "show only compactions that match the regex");
        opts.addOption(this.filterOption);
        this.tserverOption = new Option("ts", "tabletServer", true, "tablet server or compactor to list compactions for");
        this.tserverOption.setArgName("tablet server");
        opts.addOption(this.tserverOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        opts.addOption(this.disablePaginationOpt);
        return opts;
    }
}

