/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ImportConfiguration;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ImportTableCommand
extends Shell.Command {
    private Option keepMappingsOption;
    private Option keepOfflineOption;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        Set importDirs = Arrays.stream(cl.getArgs()).skip(1L).collect(Collectors.toSet());
        String tableName = cl.getArgs()[0];
        boolean keepMappings = cl.hasOption(this.keepMappingsOption.getOpt());
        boolean keepOffline = cl.hasOption(this.keepOfflineOption.getOpt());
        ImportConfiguration ic = ImportConfiguration.builder().setKeepMappings(keepMappings).setKeepOffline(keepOffline).build();
        shellState.getAccumuloClient().tableOperations().importTable(tableName, importDirs, ic);
        return 0;
    }

    @Override
    public String usage() {
        return this.getName() + " <table name> <import dir>{ <import dir>}";
    }

    @Override
    public String description() {
        return "imports a table";
    }

    @Override
    public int numArgs() {
        return -1;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        this.keepMappingsOption = new Option("m", "mapping", false, "keep the mapping file after importing.");
        opts.addOption(this.keepMappingsOption);
        this.keepOfflineOption = new Option("o", "offline", false, "do not bring the table online after importing.");
        opts.addOption(this.keepOfflineOption);
        return opts;
    }
}

