/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.gc.metrics.GcCycleMetrics;

public class GcMetrics
implements MetricsProducer {
    private final GcCycleMetrics metricValues;

    public GcMetrics(SimpleGarbageCollector gc) {
        this.metricValues = gc.getGcCycleMetrics();
    }

    public void registerMetrics(MeterRegistry registry) {
        Gauge.builder((String)"accumulo.gc.started", (Object)this.metricValues, v -> v.getLastCollect().getStarted()).description("Timestamp GC file collection cycle started").register(registry);
        Gauge.builder((String)"accumulo.gc.finished", (Object)this.metricValues, v -> v.getLastCollect().getFinished()).description("Timestamp GC file collect cycle finished").register(registry);
        Gauge.builder((String)"accumulo.gc.candidates", (Object)this.metricValues, v -> v.getLastCollect().getCandidates()).description("Number of files that are candidates for deletion").register(registry);
        Gauge.builder((String)"accumulo.gc.in.use", (Object)this.metricValues, v -> v.getLastCollect().getInUse()).description("Number of candidate files still in use").register(registry);
        Gauge.builder((String)"accumulo.gc.deleted", (Object)this.metricValues, v -> v.getLastCollect().getDeleted()).description("Number of candidate files deleted").register(registry);
        Gauge.builder((String)"accumulo.gc.errors", (Object)this.metricValues, v -> v.getLastCollect().getErrors()).description("Number of candidate deletion errors").register(registry);
        Gauge.builder((String)"accumulo.gc.wal.started", (Object)this.metricValues, v -> v.getLastWalCollect().getStarted()).description("Timestamp GC WAL collection cycle started").register(registry);
        Gauge.builder((String)"accumulo.gc.wal.finished", (Object)this.metricValues, v -> v.getLastWalCollect().getFinished()).description("Timestamp GC WAL collect cycle finished").register(registry);
        Gauge.builder((String)"accumulo.gc.wal.candidates", (Object)this.metricValues, v -> v.getLastWalCollect().getCandidates()).description("Number of files that are candidates for deletion").register(registry);
        Gauge.builder((String)"accumulo.gc.wal.in.use", (Object)this.metricValues, v -> v.getLastWalCollect().getInUse()).description("Number of wal file candidates that are still in use").register(registry);
        Gauge.builder((String)"accumulo.gc.wal.deleted", (Object)this.metricValues, v -> v.getLastWalCollect().getDeleted()).description("Number of candidate wal files deleted").register(registry);
        Gauge.builder((String)"accumulo.gc.wal.errors", (Object)this.metricValues, v -> v.getLastWalCollect().getErrors()).description("Number candidate wal file deletion errors").register(registry);
        Gauge.builder((String)"accumulo.gc.post.op.duration", (Object)this.metricValues, v -> TimeUnit.NANOSECONDS.toMillis(v.getPostOpDurationNanos())).description("GC metadata table post operation duration in milliseconds").register(registry);
        Gauge.builder((String)"accumulo.gc.run.cycle", (Object)this.metricValues, GcCycleMetrics::getRunCycleCount).description("gauge incremented each gc cycle run, rest on process start").register(registry);
    }
}

