/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;
import org.apache.datasketches.quantilescommon.SortedView;

public interface FloatsSortedView
extends SortedView {
    public float getQuantile(double var1, QuantileSearchCriteria var3);

    public double getRank(float var1, QuantileSearchCriteria var2);

    default public double[] getCDF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        QuantilesUtil.checkFloatsSplitPointsOrder(splitPoints);
        int len = splitPoints.length + 1;
        double[] buckets = new double[len];
        for (int i = 0; i < len - 1; ++i) {
            buckets[i] = this.getRank(splitPoints[i], searchCrit);
        }
        buckets[len - 1] = 1.0;
        return buckets;
    }

    default public double[] getPMF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        int len;
        double[] buckets = this.getCDF(splitPoints, searchCrit);
        int i = len = buckets.length;
        while (i-- > 1) {
            int n = i;
            buckets[n] = buckets[n] - buckets[i - 1];
        }
        return buckets;
    }

    public float[] getQuantiles();

    @Override
    public FloatsSortedViewIterator iterator();
}

