/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.threads;

import java.util.OptionalInt;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.util.threads.NamedRunnable;
import org.apache.accumulo.core.util.threads.Threads;

class NamedThreadFactory
implements ThreadFactory {
    private static final String FORMAT = "%s-%s-%d";
    private final AtomicInteger threadNum = new AtomicInteger(1);
    private final String name;
    private final OptionalInt priority;
    private final Thread.UncaughtExceptionHandler handler;

    NamedThreadFactory(String name, Thread.UncaughtExceptionHandler ueh) {
        this(name, OptionalInt.empty(), ueh);
    }

    NamedThreadFactory(String name, OptionalInt priority, Thread.UncaughtExceptionHandler ueh) {
        this.name = name;
        this.priority = priority;
        this.handler = ueh;
    }

    @Override
    public Thread newThread(Runnable r) {
        String threadName = null;
        if (r instanceof NamedRunnable) {
            NamedRunnable nr = (NamedRunnable)r;
            threadName = String.format(FORMAT, this.name, nr.getName(), this.threadNum.getAndIncrement());
        } else {
            threadName = String.format(FORMAT, this.name, r.getClass().getSimpleName(), this.threadNum.getAndIncrement());
        }
        return Threads.createNonCriticalThread(threadName, this.priority, r, this.handler);
    }
}

