/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.logging;

import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletLogger {
    private static final String PREFIX = "org.apache.accumulo.tablet.";
    private static final Logger locLog = LoggerFactory.getLogger((String)"org.apache.accumulo.tablet.location");
    private static final Logger fileLog = LoggerFactory.getLogger((String)"org.apache.accumulo.tablet.files");
    private static final Logger recoveryLog = LoggerFactory.getLogger((String)"org.apache.accumulo.tablet.recovery");
    private static final Logger walsLog = LoggerFactory.getLogger((String)"org.apache.accumulo.tablet.walogs");

    public static void assigned(KeyExtent extent, TServerInstance server) {
        locLog.debug("Assigned {} to {}", (Object)extent, (Object)server);
    }

    public static void loading(KeyExtent extent, TServerInstance server) {
        locLog.debug("Loading {} on {}", (Object)extent, (Object)server);
    }

    public static void suspended(KeyExtent extent, HostAndPort server, long time, TimeUnit timeUnit, int numWalogs) {
        locLog.debug("Suspended {} to {} at {} ms with {} walogs", new Object[]{extent, server, timeUnit.toMillis(time), numWalogs});
    }

    public static void unsuspended(KeyExtent extent) {
        locLog.debug("Unsuspended " + String.valueOf(extent));
    }

    public static void loaded(KeyExtent extent, TServerInstance server) {
        locLog.debug("Loaded {} on {}", (Object)extent, (Object)server);
    }

    public static void unassigned(KeyExtent extent, int logCount) {
        locLog.debug("Unassigned {} with {} walogs", (Object)extent, (Object)logCount);
    }

    public static void split(KeyExtent parent, KeyExtent lowChild, KeyExtent highChild, TServerInstance server) {
        locLog.debug("Split {} into {} and {} on {}", new Object[]{parent, lowChild, highChild, server});
    }

    public static void missassigned(KeyExtent extent, String goalState, String currentState, TServerInstance future, TServerInstance current, int walogs) {
        if (!goalState.equals(currentState)) {
            locLog.trace("Miss-assigned {} goal:{} current:{} future:{} location:{} walogs:{}", new Object[]{extent, goalState, currentState, future, current, walogs});
        }
    }

    private static String getSize(Collection<CompactableFile> files) {
        long sum = files.stream().mapToLong(CompactableFile::getEstimatedSize).sum();
        return FileUtils.byteCountToDisplaySize((long)sum);
    }

    private static Collection<String> asFileNames(Collection<CompactableFile> files) {
        return Collections2.transform(files, CompactableFile::getFileName);
    }

    public static void selected(KeyExtent extent, CompactionKind kind, Collection<? extends TabletFile> inputs) {
        fileLog.trace("{} changed compaction selection set for {} new set {}", new Object[]{extent, kind, Collections2.transform(inputs, TabletFile::getFileName)});
    }

    public static void compacting(KeyExtent extent, CompactionJob job, CompactionConfig config) {
        if (fileLog.isDebugEnabled()) {
            if (config == null) {
                fileLog.debug("Compacting {} on {} for {} from {} size {}", new Object[]{extent, job.getExecutor(), job.getKind(), TabletLogger.asFileNames(job.getFiles()), TabletLogger.getSize(job.getFiles())});
            } else {
                fileLog.debug("Compacting {} on {} for {} from {} size {} config {}", new Object[]{extent, job.getExecutor(), job.getKind(), TabletLogger.asFileNames(job.getFiles()), TabletLogger.getSize(job.getFiles()), config});
            }
        }
    }

    public static void compacted(KeyExtent extent, CompactionJob job, TabletFile output) {
        fileLog.debug("Compacted {} for {} created {} from {}", new Object[]{extent, job.getKind(), output, TabletLogger.asFileNames(job.getFiles())});
    }

    public static void flushed(KeyExtent extent, Optional<StoredTabletFile> newDatafile) {
        if (newDatafile.isPresent()) {
            fileLog.debug("Flushed {} created {} from [memory]", (Object)extent, (Object)newDatafile.orElseThrow());
        } else {
            fileLog.debug("Flushed {} from [memory] but no file was written.", (Object)extent);
        }
    }

    public static void bulkImported(KeyExtent extent, TabletFile file) {
        fileLog.debug("Imported {} {}  ", (Object)extent, (Object)file);
    }

    public static void recovering(KeyExtent extent, List<LogEntry> logEntries) {
        if (recoveryLog.isDebugEnabled()) {
            List logIds = logEntries.stream().map(LogEntry::getUniqueID).collect(Collectors.toList());
            recoveryLog.debug("For {} recovering data from walogs: {}", (Object)extent, logIds);
        }
    }

    public static void recovered(KeyExtent extent, List<LogEntry> logEntries, long numMutation, long numEntries) {
        recoveryLog.info("For {} recovered {} mutations creating {} entries from {} walogs", new Object[]{extent, numMutation, numEntries, logEntries.size()});
    }

    public static boolean isWalRefLoggingEnabled() {
        return walsLog.isTraceEnabled();
    }

    public static void walRefsChanged(KeyExtent extent, Collection<String> refsSupplier) {
        walsLog.trace("{} has unflushed data in wals: {} ", (Object)extent, refsSupplier);
    }
}

