/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.schema.Ample;

public class Writer {
    private ClientContext context;
    private TableId tableId;

    public Writer(ClientContext context, TableId tableId) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        this.context = context;
        this.tableId = tableId;
    }

    public void update(Mutation m) throws AccumuloException, TableNotFoundException {
        Preconditions.checkArgument((m != null ? 1 : 0) != 0, (Object)"m is null");
        if (m.size() == 0) {
            throw new IllegalArgumentException("Can not add empty mutations");
        }
        String table = Ample.DataLevel.of(this.tableId).metaTable();
        try (BatchWriter writer = this.context.createBatchWriter(table);){
            writer.addMutation(m);
        }
    }
}

