/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.blockfile.cache.impl.BlockCacheConfiguration;
import org.apache.accumulo.core.file.blockfile.cache.impl.NoopCache;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.CacheType;

public abstract class BlockCacheManager {
    private final Map<CacheType, BlockCache> caches = new HashMap<CacheType, BlockCache>();

    public void start(Configuration conf) {
        Supplier<NoopCache> noop = () -> new NoopCache();
        for (CacheType type : CacheType.values()) {
            if (conf.getMaxSize(type) > 0L) {
                this.caches.put(type, this.createCache(conf, type));
                continue;
            }
            this.caches.put(type, noop.get());
        }
    }

    public void stop() {
        this.caches.clear();
    }

    public BlockCache getBlockCache(CacheType type) {
        return this.caches.get((Object)type);
    }

    protected abstract BlockCache createCache(Configuration var1, CacheType var2);

    @Deprecated(since="2.1.0")
    public static String getFullyQualifiedPropertyPrefix(String prefix) {
        return BlockCacheConfiguration.getFullyQualifiedPropertyPrefix(Property.TSERV_PREFIX, prefix);
    }

    @Deprecated(since="2.1.0")
    public static String getFullyQualifiedPropertyPrefix(String prefix, CacheType type) {
        return BlockCacheConfiguration.getFullyQualifiedPropertyPrefix(Property.TSERV_PREFIX, prefix, type);
    }

    public static interface Configuration {
        public long getMaxSize(CacheType var1);

        public long getBlockSize();

        public Map<String, String> getProperties(String var1, CacheType var2);
    }
}

