/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.lru;

import java.util.LinkedList;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.accumulo.core.file.blockfile.cache.lru.CachedBlock;
import org.apache.accumulo.core.file.blockfile.cache.lru.HeapSize;

public class CachedBlockQueue
implements HeapSize {
    private final PriorityQueue<CachedBlock> queue;
    private long heapSize;
    private final long maxSize;

    public CachedBlockQueue(long maxSize, long blockSize) {
        int initialSize = (int)Math.ceil((double)maxSize / (double)blockSize);
        if (initialSize == 0) {
            ++initialSize;
        }
        this.queue = new PriorityQueue(initialSize);
        this.heapSize = 0L;
        this.maxSize = maxSize;
    }

    public void add(CachedBlock cb) {
        if (this.heapSize < this.maxSize) {
            this.queue.add(cb);
            this.heapSize += cb.heapSize();
        } else {
            CachedBlock head = Objects.requireNonNull(this.queue.peek(), "No cached blocks available from queue");
            if (cb.compareTo(head) > 0) {
                this.heapSize += cb.heapSize();
                this.heapSize -= head.heapSize();
                if (this.heapSize > this.maxSize) {
                    this.queue.poll();
                } else {
                    this.heapSize += head.heapSize();
                }
                this.queue.add(cb);
            }
        }
    }

    public CachedBlock[] get() {
        LinkedList<CachedBlock> blocks = new LinkedList<CachedBlock>();
        while (!this.queue.isEmpty()) {
            blocks.addFirst(this.queue.poll());
        }
        return blocks.toArray(new CachedBlock[0]);
    }

    @Override
    public long heapSize() {
        return this.heapSize;
    }
}

