/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import com.google.common.base.Preconditions;
import java.util.Objects;

public enum FilePrefix {
    FLUSH('F'),
    BULK_IMPORT('I'),
    COMPACTION('C'),
    FULL_COMPACTION('A'),
    MERGING_MINOR_COMPACTION('M');

    private final char filePrefix;

    private FilePrefix(char prefix) {
        this.filePrefix = prefix;
    }

    public char getPrefix() {
        return this.filePrefix;
    }

    public String createFileName(String fileSuffix) {
        Objects.requireNonNull(fileSuffix, "fileSuffix must be supplied");
        Preconditions.checkArgument((!fileSuffix.isBlank() ? 1 : 0) != 0, (Object)"Empty fileSuffix supplied");
        if (this == MERGING_MINOR_COMPACTION) {
            throw new IllegalStateException("Unable to create filename for MERGING_MINOR_COMPACTION file type");
        }
        return this.filePrefix + fileSuffix;
    }

    public static FilePrefix fromPrefix(char prefix) {
        for (FilePrefix fp : FilePrefix.values()) {
            if (fp.filePrefix != prefix) continue;
            return fp;
        }
        throw new IllegalArgumentException("Unknown prefix type: " + prefix);
    }

    public static FilePrefix fromFileName(String fileName) {
        Objects.requireNonNull(fileName, "file name must be supplied");
        Preconditions.checkArgument((!fileName.isBlank() ? 1 : 0) != 0, (Object)"Empty filename supplied");
        char firstChar = fileName.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            throw new IllegalArgumentException("Expected first character of file name to be upper case, name: " + fileName);
        }
        return FilePrefix.fromPrefix(firstChar);
    }
}

