/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate.zookeeper;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooSession;
import org.apache.accumulo.core.util.Retry;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooReader {
    private static final Logger log = LoggerFactory.getLogger(ZooReader.class);
    protected static final Retry.RetryFactory RETRY_FACTORY = Retry.builder().maxRetries(10L).retryAfter(250L, TimeUnit.MILLISECONDS).incrementBy(250L, TimeUnit.MILLISECONDS).maxWait(2L, TimeUnit.MINUTES).backOffFactor(1.5).logInterval(3L, TimeUnit.MINUTES).createFactory();
    protected final String keepers;
    protected final int timeout;

    public ZooReader(String keepers, int timeout) {
        this.keepers = Objects.requireNonNull(keepers);
        this.timeout = timeout;
    }

    public ZooReaderWriter asWriter(String secret) {
        return new ZooReaderWriter(this.keepers, this.timeout, secret);
    }

    protected ZooKeeper getZooKeeper() {
        return ZooSession.getAnonymousSession(this.keepers, this.timeout);
    }

    protected Retry.RetryFactory getRetryFactory() {
        return RETRY_FACTORY;
    }

    public int getSessionTimeout() {
        return this.timeout;
    }

    public byte[] getData(String zPath) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.getData(zPath, null, null));
    }

    public byte[] getData(String zPath, Stat stat) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.getData(zPath, null, Objects.requireNonNull(stat)));
    }

    public byte[] getData(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.getData(zPath, Objects.requireNonNull(watcher), null));
    }

    public byte[] getData(String zPath, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.getData(zPath, Objects.requireNonNull(watcher), Objects.requireNonNull(stat)));
    }

    public Stat getStatus(String zPath) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.exists(zPath, null));
    }

    public Stat getStatus(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.exists(zPath, Objects.requireNonNull(watcher)));
    }

    public List<String> getChildren(String zPath) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.getChildren(zPath, null));
    }

    public List<String> getChildren(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.getChildren(zPath, Objects.requireNonNull(watcher)));
    }

    public boolean exists(String zPath) throws KeeperException, InterruptedException {
        return this.getStatus(zPath) != null;
    }

    public boolean exists(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        return this.getStatus(zPath, watcher) != null;
    }

    public void sync(String path) throws KeeperException, InterruptedException {
        AtomicInteger rc = new AtomicInteger();
        CountDownLatch waiter = new CountDownLatch(1);
        this.getZooKeeper().sync(path, (code, arg1, arg2) -> {
            rc.set(code);
            waiter.countDown();
        }, null);
        waiter.await();
        KeeperException.Code code2 = KeeperException.Code.get((int)rc.get());
        if (code2 != KeeperException.Code.OK) {
            throw KeeperException.create((KeeperException.Code)code2);
        }
    }

    protected <R> R retryLoop(ZKFunction<R> f) throws KeeperException, InterruptedException {
        return this.retryLoop(f, e -> false);
    }

    protected <R> R retryLoop(ZKFunction<R> zkf, Predicate<KeeperException> alwaysRetryCondition) throws KeeperException, InterruptedException {
        try {
            return (R)this.retryLoopMutator(zkf::apply, alwaysRetryCondition);
        }
        catch (AcceptableThriftTableOperationException e) {
            throw new AssertionError((Object)("Not possible; " + ZKFunction.class.getName() + " can't throw " + AcceptableThriftTableOperationException.class.getName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <R> R retryLoopMutator(ZKFunctionMutator<R> zkf, Predicate<KeeperException> alwaysRetryCondition) throws KeeperException, InterruptedException, AcceptableThriftTableOperationException {
        Objects.requireNonNull(zkf);
        Objects.requireNonNull(alwaysRetryCondition);
        Retry retries = this.getRetryFactory().createRetry();
        while (true) {
            try {
                return zkf.apply(this.getZooKeeper());
            }
            catch (KeeperException e) {
                if (alwaysRetryCondition.test(e)) {
                    retries.waitForNextAttempt(log, "attempting to communicate with zookeeper after exception that always requires retry: " + e.getMessage());
                    continue;
                }
                if (!ZooReader.useRetryForTransient(retries, e)) throw e;
                continue;
            }
            break;
        }
    }

    private static boolean useRetryForTransient(Retry retries, KeeperException e) throws KeeperException, InterruptedException {
        KeeperException.Code c = e.code();
        if (c == KeeperException.Code.CONNECTIONLOSS || c == KeeperException.Code.OPERATIONTIMEOUT || c == KeeperException.Code.SESSIONEXPIRED) {
            log.warn("Saw (possibly) transient exception communicating with ZooKeeper", (Throwable)e);
            if (retries.canRetry()) {
                retries.useRetry();
                retries.waitForNextAttempt(log, "attempting to communicate with zookeeper after exception: " + e.getMessage());
                return true;
            }
            log.error("Retry attempts ({}) exceeded trying to communicate with ZooKeeper", (Object)retries.retriesCompleted());
        }
        return false;
    }

    protected static interface ZKFunction<R> {
        public R apply(ZooKeeper var1) throws KeeperException, InterruptedException;
    }

    protected static interface ZKFunctionMutator<R> {
        public R apply(ZooKeeper var1) throws KeeperException, InterruptedException, AcceptableThriftTableOperationException;
    }
}

