/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.dataImpl;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class KeyExtent
implements Comparable<KeyExtent> {
    private static final String OBSCURING_HASH_ALGORITHM = "SHA-256";
    private final TableId tableId;
    private final Text endRow;
    private final Text prevEndRow;
    private volatile int hashCode = 0;
    private static final Text EMPTY_TEXT = new Text("");
    private static final Comparator<KeyExtent> COMPARATOR = Comparator.comparing(KeyExtent::tableId).thenComparing(KeyExtent::endRow, Comparator.nullsLast(BinaryComparable::compareTo)).thenComparing(KeyExtent::prevEndRow, Comparator.nullsFirst(BinaryComparable::compareTo));

    public KeyExtent(TableId table, Text endRow, Text prevEndRow) {
        this.tableId = Objects.requireNonNull(table, "null table ID not allowed");
        if (endRow != null && prevEndRow != null && prevEndRow.compareTo((BinaryComparable)endRow) >= 0) {
            throw new IllegalArgumentException("prevEndRow (" + String.valueOf(prevEndRow) + ") >= endRow (" + String.valueOf(endRow) + ")");
        }
        this.endRow = endRow == null ? null : new Text(endRow);
        this.prevEndRow = prevEndRow == null ? null : new Text(prevEndRow);
    }

    public static KeyExtent copyOf(KeyExtent original) {
        return new KeyExtent(original.tableId(), original.endRow(), original.prevEndRow());
    }

    public static KeyExtent fromThrift(TKeyExtent tke) {
        TableId tableId = TableId.of(new String(ByteBufferUtil.toBytes(tke.table), StandardCharsets.UTF_8));
        Text endRow = tke.endRow == null ? null : new Text(ByteBufferUtil.toBytes(tke.endRow));
        Text prevEndRow = tke.prevEndRow == null ? null : new Text(ByteBufferUtil.toBytes(tke.prevEndRow));
        return new KeyExtent(tableId, endRow, prevEndRow);
    }

    public TKeyExtent toThrift() {
        return new TKeyExtent(ByteBuffer.wrap(this.tableId().canonical().getBytes(StandardCharsets.UTF_8)), this.endRow() == null ? null : TextUtil.getByteBuffer(this.endRow()), this.prevEndRow() == null ? null : TextUtil.getByteBuffer(this.prevEndRow()));
    }

    public static KeyExtent fromMetaPrevRow(Map.Entry<Key, Value> prevRowEntry) {
        return KeyExtent.fromMetaRow(prevRowEntry.getKey().getRow(), MetadataSchema.TabletsSection.TabletColumnFamily.decodePrevEndRow(prevRowEntry.getValue()));
    }

    public static KeyExtent fromMetaRow(Text encodedMetadataRow) {
        return KeyExtent.fromMetaRow(encodedMetadataRow, null);
    }

    public static KeyExtent fromMetaRow(Text encodedMetadataRow, Text prevEndRow) {
        Pair<TableId, Text> tableIdAndEndRow = MetadataSchema.TabletsSection.decodeRow(encodedMetadataRow);
        TableId tableId = tableIdAndEndRow.getFirst();
        Text endRow = tableIdAndEndRow.getSecond();
        return new KeyExtent(tableId, endRow, prevEndRow);
    }

    public static KeyExtent fromTabletId(TabletId tabletId) {
        if (tabletId instanceof TabletIdImpl) {
            return ((TabletIdImpl)tabletId).toKeyExtent();
        }
        return new KeyExtent(tabletId.getTable(), tabletId.getEndRow(), tabletId.getPrevEndRow());
    }

    public Text toMetaRow() {
        return MetadataSchema.TabletsSection.encodeRow(this.tableId(), this.endRow());
    }

    public TableId tableId() {
        return this.tableId;
    }

    public Text endRow() {
        return this.endRow;
    }

    public Text prevEndRow() {
        return this.prevEndRow;
    }

    public static KeyExtent readFrom(DataInput in) throws IOException {
        boolean hasPrevRow;
        Text tid = new Text();
        tid.readFields(in);
        TableId tableId = TableId.of(tid.toString());
        Text endRow = null;
        Text prevEndRow = null;
        boolean hasRow = in.readBoolean();
        if (hasRow) {
            endRow = new Text();
            endRow.readFields(in);
        }
        if (hasPrevRow = in.readBoolean()) {
            prevEndRow = new Text();
            prevEndRow.readFields(in);
        }
        return new KeyExtent(tableId, endRow, prevEndRow);
    }

    public void writeTo(DataOutput out) throws IOException {
        new Text(this.tableId().canonical()).write(out);
        if (this.endRow() != null) {
            out.writeBoolean(true);
            this.endRow().write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.prevEndRow() != null) {
            out.writeBoolean(true);
            this.prevEndRow().write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public int compareTo(KeyExtent other) {
        return COMPARATOR.compare(this, other);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int tmpHashCode = this.tableId().hashCode();
        tmpHashCode += this.endRow() == null ? 0 : this.endRow().hashCode();
        this.hashCode = tmpHashCode += this.prevEndRow() == null ? 0 : this.prevEndRow().hashCode();
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyExtent)) {
            return false;
        }
        KeyExtent oke = (KeyExtent)o;
        return this.tableId().equals(oke.tableId()) && Objects.equals(this.endRow(), oke.endRow()) && Objects.equals(this.prevEndRow(), oke.prevEndRow());
    }

    public String toString() {
        String tableIdString = this.tableId().canonical().replaceAll(";", "\\\\;").replaceAll("\\\\", "\\\\\\\\");
        Object endRowString = this.endRow() == null ? "<" : ";" + TextUtil.truncate(this.endRow()).toString().replaceAll(";", "\\\\;").replaceAll("\\\\", "\\\\\\\\");
        Object prevEndRowString = this.prevEndRow() == null ? "<" : ";" + TextUtil.truncate(this.prevEndRow()).toString().replaceAll(";", "\\\\;").replaceAll("\\\\", "\\\\\\\\");
        return tableIdString + (String)endRowString + (String)prevEndRowString;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public UUID getUUID() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            UUID uUID;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                this.writeTo(dos);
                uUID = UUID.nameUUIDFromBytes(baos.toByteArray());
            }
            return uUID;
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public boolean contains(KeyExtent oke) {
        boolean containsPrevRow = this.prevEndRow() == null || oke.prevEndRow() != null && this.prevEndRow().compareTo((BinaryComparable)oke.prevEndRow()) <= 0;
        boolean containsEndRow = this.endRow() == null || oke.endRow() != null && this.endRow().compareTo((BinaryComparable)oke.endRow()) >= 0;
        return containsPrevRow && containsEndRow;
    }

    public boolean contains(BinaryComparable row) {
        if (row == null) {
            throw new IllegalArgumentException("Passing null to contains is ambiguous, could be in first or last extent of table");
        }
        return !(this.prevEndRow() != null && this.prevEndRow().compareTo(row) >= 0 || this.endRow() != null && this.endRow().compareTo(row) < 0);
    }

    public Range toDataRange() {
        return new Range(this.prevEndRow(), false, this.endRow(), true);
    }

    public Range toMetaRange() {
        Text metadataPrevRow = MetadataSchema.TabletsSection.encodeRow(this.tableId(), this.prevEndRow() == null ? EMPTY_TEXT : this.prevEndRow());
        return new Range(metadataPrevRow, this.prevEndRow() == null, this.toMetaRow(), true);
    }

    private boolean startsAfter(KeyExtent other) {
        KeyExtent nke = Objects.requireNonNull(other);
        return this.tableId().compareTo(nke.tableId()) > 0 || this.prevEndRow() != null && nke.endRow() != null && this.prevEndRow().compareTo((BinaryComparable)nke.endRow()) >= 0;
    }

    private static Text rowAfterPrevRow(KeyExtent nke) {
        Text row = new Text(nke.prevEndRow());
        row.append(new byte[]{0}, 0, 1);
        return row;
    }

    public static Set<KeyExtent> findOverlapping(KeyExtent nke, SortedSet<KeyExtent> extents) {
        KeyExtent ke;
        SortedSet<KeyExtent> start;
        if (nke == null || extents == null || extents.isEmpty()) {
            return Collections.emptySet();
        }
        if (nke.prevEndRow() != null) {
            Text row = KeyExtent.rowAfterPrevRow(nke);
            KeyExtent lookupKey = new KeyExtent(nke.tableId(), row, null);
            start = extents.tailSet(lookupKey);
        } else {
            KeyExtent lookupKey = new KeyExtent(nke.tableId(), new Text(), null);
            start = extents.tailSet(lookupKey);
        }
        TreeSet<KeyExtent> result = new TreeSet<KeyExtent>();
        Iterator iterator = start.iterator();
        while (iterator.hasNext() && !(ke = (KeyExtent)iterator.next()).startsAfter(nke)) {
            result.add(ke);
        }
        return result;
    }

    public boolean overlaps(KeyExtent other) {
        TreeSet<KeyExtent> set = new TreeSet<KeyExtent>();
        set.add(other);
        return !KeyExtent.findOverlapping(this, set).isEmpty();
    }

    public static Set<KeyExtent> findOverlapping(KeyExtent nke, SortedMap<KeyExtent, ?> extents) {
        Map.Entry<KeyExtent, ?> entry;
        KeyExtent ke;
        SortedMap<KeyExtent, ?> start;
        if (nke == null || extents == null || extents.isEmpty()) {
            return Collections.emptySet();
        }
        if (nke.prevEndRow() != null) {
            Text row = KeyExtent.rowAfterPrevRow(nke);
            KeyExtent lookupKey = new KeyExtent(nke.tableId(), row, null);
            start = extents.tailMap(lookupKey);
        } else {
            KeyExtent lookupKey = new KeyExtent(nke.tableId(), new Text(), null);
            start = extents.tailMap(lookupKey);
        }
        TreeSet<KeyExtent> result = new TreeSet<KeyExtent>();
        Iterator<Map.Entry<KeyExtent, ?>> iterator = start.entrySet().iterator();
        while (iterator.hasNext() && !(ke = (entry = iterator.next()).getKey()).startsAfter(nke)) {
            result.add(ke);
        }
        return result;
    }

    public boolean isPreviousExtent(KeyExtent prevExtent) {
        if (prevExtent == null) {
            return this.prevEndRow() == null;
        }
        if (!prevExtent.tableId().equals(this.tableId())) {
            throw new IllegalArgumentException("Cannot compare across tables " + String.valueOf(prevExtent) + " " + String.valueOf(this));
        }
        if (prevExtent.endRow() == null || this.prevEndRow() == null) {
            return false;
        }
        return prevExtent.endRow().equals((Object)this.prevEndRow());
    }

    public boolean isMeta() {
        return this.tableId().equals(MetadataTable.ID) || this.isRootTablet();
    }

    public boolean isRootTablet() {
        return this.tableId().equals(RootTable.ID);
    }

    public String obscured() {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance(OBSCURING_HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (this.endRow() != null && this.endRow().getLength() > 0) {
            digester.update(this.endRow().getBytes(), 0, this.endRow().getLength());
        }
        return Base64.getEncoder().encodeToString(digester.digest());
    }
}

