/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.io.Text;

public class Condition {
    private final ByteSequence cf;
    private final ByteSequence cq;
    private ByteSequence cv;
    private ByteSequence val;
    private Long ts;
    private IteratorSetting[] iterators = new IteratorSetting[0];
    private static final ByteSequence EMPTY = new ArrayByteSequence(new byte[0]);

    public Condition(CharSequence cf, CharSequence cq) {
        Preconditions.checkArgument((cf != null ? 1 : 0) != 0, (Object)"cf is null");
        Preconditions.checkArgument((cq != null ? 1 : 0) != 0, (Object)"cq is null");
        this.cf = new ArrayByteSequence(cf.toString().getBytes(StandardCharsets.UTF_8));
        this.cq = new ArrayByteSequence(cq.toString().getBytes(StandardCharsets.UTF_8));
        this.cv = EMPTY;
    }

    public Condition(byte[] cf, byte[] cq) {
        Preconditions.checkArgument((cf != null ? 1 : 0) != 0, (Object)"cf is null");
        Preconditions.checkArgument((cq != null ? 1 : 0) != 0, (Object)"cq is null");
        this.cf = new ArrayByteSequence(cf);
        this.cq = new ArrayByteSequence(cq);
        this.cv = EMPTY;
    }

    public Condition(Text cf, Text cq) {
        Preconditions.checkArgument((cf != null ? 1 : 0) != 0, (Object)"cf is null");
        Preconditions.checkArgument((cq != null ? 1 : 0) != 0, (Object)"cq is null");
        this.cf = new ArrayByteSequence(cf.getBytes(), 0, cf.getLength());
        this.cq = new ArrayByteSequence(cq.getBytes(), 0, cq.getLength());
        this.cv = EMPTY;
    }

    public Condition(ByteSequence cf, ByteSequence cq) {
        Preconditions.checkArgument((cf != null ? 1 : 0) != 0, (Object)"cf is null");
        Preconditions.checkArgument((cq != null ? 1 : 0) != 0, (Object)"cq is null");
        this.cf = cf;
        this.cq = cq;
        this.cv = EMPTY;
    }

    public ByteSequence getFamily() {
        return this.cf;
    }

    public ByteSequence getQualifier() {
        return this.cq;
    }

    public Condition setTimestamp(long ts) {
        this.ts = ts;
        return this;
    }

    public Long getTimestamp() {
        return this.ts;
    }

    public Condition setValue(CharSequence value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        this.val = new ArrayByteSequence(value.toString().getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public Condition setValue(byte[] value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        this.val = new ArrayByteSequence(value);
        return this;
    }

    public Condition setValue(Text value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        this.val = new ArrayByteSequence(value.getBytes(), 0, value.getLength());
        return this;
    }

    public Condition setValue(ByteSequence value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        this.val = value;
        return this;
    }

    public ByteSequence getValue() {
        return this.val;
    }

    public Condition setVisibility(ColumnVisibility cv) {
        Preconditions.checkArgument((cv != null ? 1 : 0) != 0, (Object)"cv is null");
        this.cv = new ArrayByteSequence(cv.getExpression());
        return this;
    }

    public ByteSequence getVisibility() {
        return this.cv;
    }

    public Condition setIterators(IteratorSetting ... iterators) {
        Preconditions.checkArgument((iterators != null ? 1 : 0) != 0, (Object)"iterators is null");
        if (iterators.length > 1) {
            HashSet<String> names = new HashSet<String>();
            HashSet<Integer> prios = new HashSet<Integer>();
            for (IteratorSetting iteratorSetting : iterators) {
                if (!names.add(iteratorSetting.getName())) {
                    throw new IllegalArgumentException("iterator name used more than once " + iteratorSetting.getName());
                }
                if (prios.add(iteratorSetting.getPriority())) continue;
                throw new IllegalArgumentException("iterator priority used more than once " + iteratorSetting.getPriority());
            }
        }
        this.iterators = iterators;
        return this;
    }

    public IteratorSetting[] getIterators() {
        return this.iterators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Condition)) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.cf, condition.cf) && Objects.equals(this.cq, condition.cq) && Objects.equals(this.cv, condition.cv) && Objects.equals(this.val, condition.val) && Objects.equals(this.ts, condition.ts) && Arrays.equals(this.iterators, condition.iterators);
    }

    public int hashCode() {
        int result = Objects.hash(this.cf, this.cq, this.cv, this.val, this.ts);
        result = 31 * result + Arrays.hashCode(this.iterators);
        return result;
    }
}

