/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.mapreduce.lib;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.mapreduce.lib.ConfiguratorBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class InputConfigurator
extends ConfiguratorBase {
    public static void setClassLoaderContext(Class<?> implementingClass, Configuration conf, String context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        conf.set(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.CLASSLOADER_CONTEXT), context);
    }

    public static String getClassLoaderContext(Class<?> implementingClass, Configuration conf) {
        return conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.CLASSLOADER_CONTEXT), null);
    }

    public static void setInputTableName(Class<?> implementingClass, Configuration conf, String tableName) {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        conf.set(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.TABLE_NAME), tableName);
    }

    public static String getInputTableName(Class<?> implementingClass, Configuration conf) {
        return conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.TABLE_NAME));
    }

    public static void setScanAuthorizations(Class<?> implementingClass, Configuration conf, Authorizations auths) {
        if (auths != null && !auths.isEmpty()) {
            conf.set(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.AUTHORIZATIONS), auths.serialize());
        }
    }

    public static Authorizations getScanAuthorizations(Class<?> implementingClass, Configuration conf) {
        String authString = conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.AUTHORIZATIONS));
        return authString == null ? Authorizations.EMPTY : new Authorizations(authString.getBytes(StandardCharsets.UTF_8));
    }

    public static void setRanges(Class<?> implementingClass, Configuration conf, Collection<Range> ranges) {
        Preconditions.checkArgument((ranges != null ? 1 : 0) != 0, (Object)"ranges is null");
        ArrayList<String> rangeStrings = new ArrayList<String>(ranges.size());
        try {
            for (Range r : ranges) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                r.write(new DataOutputStream(baos));
                rangeStrings.add(Base64.getEncoder().encodeToString(baos.toByteArray()));
            }
            conf.setStrings(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.RANGES), rangeStrings.toArray(new String[0]));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to encode ranges to Base64", ex);
        }
    }

    public static List<Range> getRanges(Class<?> implementingClass, Configuration conf) throws IOException {
        Collection encodedRanges = conf.getStringCollection(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.RANGES));
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String rangeString : encodedRanges) {
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(rangeString));
            Range range = new Range();
            range.readFields(new DataInputStream(bais));
            ranges.add(range);
        }
        return ranges;
    }

    public static List<IteratorSetting> getIterators(Class<?> implementingClass, Configuration conf) {
        String iterators = conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.ITERATORS));
        if (iterators == null || iterators.isEmpty()) {
            return new ArrayList<IteratorSetting>();
        }
        StringTokenizer tokens = new StringTokenizer(iterators, ",");
        ArrayList<IteratorSetting> list = new ArrayList<IteratorSetting>();
        try {
            while (tokens.hasMoreTokens()) {
                String itstring = tokens.nextToken();
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(itstring));
                list.add(new IteratorSetting(new DataInputStream(bais)));
                bais.close();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("couldn't decode iterator settings");
        }
        return list;
    }

    public static void fetchColumns(Class<?> implementingClass, Configuration conf, Collection<Pair<Text, Text>> columnFamilyColumnQualifierPairs) {
        Preconditions.checkArgument((columnFamilyColumnQualifierPairs != null ? 1 : 0) != 0, (Object)"columnFamilyColumnQualifierPairs is null");
        String[] columnStrings = InputConfigurator.serializeColumns(columnFamilyColumnQualifierPairs);
        conf.setStrings(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.COLUMNS), columnStrings);
    }

    public static String[] serializeColumns(Collection<Pair<Text, Text>> columnFamilyColumnQualifierPairs) {
        Preconditions.checkArgument((columnFamilyColumnQualifierPairs != null ? 1 : 0) != 0, (Object)"columnFamilyColumnQualifierPairs is null");
        ArrayList<String> columnStrings = new ArrayList<String>(columnFamilyColumnQualifierPairs.size());
        for (Pair<Text, Text> column : columnFamilyColumnQualifierPairs) {
            if (column.getFirst() == null) {
                throw new IllegalArgumentException("Column family can not be null");
            }
            Object col = Base64.getEncoder().encodeToString(TextUtil.getBytes(column.getFirst()));
            if (column.getSecond() != null) {
                col = (String)col + ":" + Base64.getEncoder().encodeToString(TextUtil.getBytes(column.getSecond()));
            }
            columnStrings.add((String)col);
        }
        return columnStrings.toArray(new String[0]);
    }

    public static Set<Pair<Text, Text>> getFetchedColumns(Class<?> implementingClass, Configuration conf) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"conf is null");
        String confValue = conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.COLUMNS));
        ArrayList<String> serialized = new ArrayList<String>();
        if (confValue != null) {
            Collections.addAll(serialized, confValue.split(",", -1));
        }
        return InputConfigurator.deserializeFetchedColumns(serialized);
    }

    public static Set<Pair<Text, Text>> deserializeFetchedColumns(Collection<String> serialized) {
        HashSet<Pair<Text, Text>> columns = new HashSet<Pair<Text, Text>>();
        if (serialized == null) {
            return columns;
        }
        for (String col : serialized) {
            int idx = col.indexOf(":");
            Text cf = new Text(idx < 0 ? Base64.getDecoder().decode(col) : Base64.getDecoder().decode(col.substring(0, idx)));
            Text cq = idx < 0 ? null : new Text(Base64.getDecoder().decode(col.substring(idx + 1)));
            columns.add(new Pair<Text, Text>(cf, cq));
        }
        return columns;
    }

    public static void addIterator(Class<?> implementingClass, Configuration conf, IteratorSetting cfg) {
        String newIter;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            cfg.write(new DataOutputStream(baos));
            newIter = Base64.getEncoder().encodeToString(baos.toByteArray());
            baos.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to serialize IteratorSetting");
        }
        String confKey = InputConfigurator.enumToConfKey(implementingClass, ScanOpts.ITERATORS);
        String iterators = conf.get(confKey);
        iterators = iterators == null || iterators.isEmpty() ? newIter : iterators.concat("," + newIter);
        conf.set(confKey, iterators);
    }

    public static void setAutoAdjustRanges(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.AUTO_ADJUST_RANGES), enableFeature);
    }

    public static Boolean getAutoAdjustRanges(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.AUTO_ADJUST_RANGES), true);
    }

    public static void setScanIsolation(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.SCAN_ISOLATION), enableFeature);
    }

    public static Boolean isIsolated(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.SCAN_ISOLATION), false);
    }

    public static void setLocalIterators(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.USE_LOCAL_ITERATORS), enableFeature);
    }

    public static Boolean usesLocalIterators(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.USE_LOCAL_ITERATORS), false);
    }

    public static void setOfflineTableScan(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.SCAN_OFFLINE), enableFeature);
    }

    public static Boolean isOfflineScan(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.SCAN_OFFLINE), false);
    }

    public static void setBatchScan(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.BATCH_SCANNER), enableFeature);
    }

    public static Boolean isBatchScan(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.BATCH_SCANNER), false);
    }

    public static void setInputTableConfigs(Class<?> implementingClass, Configuration conf, Map<String, InputTableConfig> configs) {
        MapWritable mapWritable = new MapWritable();
        for (Map.Entry<String, InputTableConfig> tableConfig : configs.entrySet()) {
            mapWritable.put((Writable)new Text(tableConfig.getKey()), (Writable)tableConfig.getValue());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mapWritable.write((DataOutput)new DataOutputStream(baos));
        }
        catch (IOException e) {
            throw new IllegalStateException("Table configuration could not be serialized.");
        }
        String confKey = InputConfigurator.enumToConfKey(implementingClass, ScanOpts.TABLE_CONFIGS);
        conf.set(confKey, Base64.getEncoder().encodeToString(baos.toByteArray()));
    }

    public static Map<String, InputTableConfig> getInputTableConfigs(Class<?> implementingClass, Configuration conf) {
        HashMap<String, InputTableConfig> configs = new HashMap<String, InputTableConfig>();
        Map.Entry<String, InputTableConfig> defaultConfig = InputConfigurator.getDefaultInputTableConfig(implementingClass, conf);
        if (defaultConfig != null) {
            configs.put(defaultConfig.getKey(), defaultConfig.getValue());
        }
        String configString = conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.TABLE_CONFIGS));
        MapWritable mapWritable = new MapWritable();
        if (configString != null) {
            try {
                byte[] bytes = Base64.getDecoder().decode(configString);
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                mapWritable.readFields((DataInput)new DataInputStream(bais));
                bais.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("The table query configurations could not be deserialized from the given configuration");
            }
        }
        for (Map.Entry entry : mapWritable.entrySet()) {
            configs.put(((Writable)entry.getKey()).toString(), (InputTableConfig)entry.getValue());
        }
        return configs;
    }

    public static InputTableConfig getInputTableConfig(Class<?> implementingClass, Configuration conf, String tableName) {
        Map<String, InputTableConfig> queryConfigs = InputConfigurator.getInputTableConfigs(implementingClass, conf);
        return queryConfigs.get(tableName);
    }

    private static String extractNamespace(String tableName) {
        int delimiterPos = tableName.indexOf(46);
        if (delimiterPos < 1) {
            return "";
        }
        return tableName.substring(0, delimiterPos);
    }

    public static void validatePermissions(Class<?> implementingClass, Configuration conf) throws IOException {
        Map<String, InputTableConfig> inputTableConfigs = InputConfigurator.getInputTableConfigs(implementingClass, conf);
        try {
            ClientContext client = InputConfigurator.client(implementingClass, conf);
            if (InputConfigurator.getInputTableConfigs(implementingClass, conf).isEmpty()) {
                throw new IOException("No table set.");
            }
            String principal = InputConfigurator.getPrincipal(implementingClass, conf);
            if (principal == null) {
                principal = client.whoami();
            }
            for (Map.Entry<String, InputTableConfig> tableConfig : inputTableConfigs.entrySet()) {
                String tableName = tableConfig.getKey();
                String namespace = InputConfigurator.extractNamespace(tableName);
                boolean hasTableRead = client.securityOperations().hasTablePermission(principal, tableName, TablePermission.READ);
                boolean hasNamespaceRead = client.securityOperations().hasNamespacePermission(principal, namespace, NamespacePermission.READ);
                if (hasTableRead || hasNamespaceRead) continue;
                throw new IOException("Unable to access table");
            }
            for (Map.Entry<String, InputTableConfig> tableConfigEntry : inputTableConfigs.entrySet()) {
                InputTableConfig tableConfig = tableConfigEntry.getValue();
                if (tableConfig.shouldUseLocalIterators() || tableConfig.getIterators() == null) continue;
                for (IteratorSetting iter : tableConfig.getIterators()) {
                    if (client.tableOperations().testClassLoad(tableConfigEntry.getKey(), iter.getIteratorClass(), SortedKeyValueIterator.class.getName())) continue;
                    throw new AccumuloException("Servers are unable to load " + iter.getIteratorClass() + " as a " + SortedKeyValueIterator.class.getName());
                }
            }
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            throw new IOException(e);
        }
    }

    protected static Map.Entry<String, InputTableConfig> getDefaultInputTableConfig(Class<?> implementingClass, Configuration conf) {
        String tableName = InputConfigurator.getInputTableName(implementingClass, conf);
        if (tableName != null) {
            SamplerConfiguration samplerConfig;
            Set<Pair<Text, Text>> columns;
            InputTableConfig queryConfig = new InputTableConfig();
            List<IteratorSetting> itrs = InputConfigurator.getIterators(implementingClass, conf);
            if (itrs != null) {
                queryConfig.setIterators(itrs);
            }
            if ((columns = InputConfigurator.getFetchedColumns(implementingClass, conf)) != null) {
                queryConfig.fetchColumns(columns);
            }
            List<Range> ranges = null;
            try {
                ranges = InputConfigurator.getRanges(implementingClass, conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (ranges != null) {
                queryConfig.setRanges(ranges);
            }
            if ((samplerConfig = InputConfigurator.getSamplerConfiguration(implementingClass, conf)) != null) {
                queryConfig.setSamplerConfiguration(samplerConfig);
            }
            queryConfig.setAutoAdjustRanges(InputConfigurator.getAutoAdjustRanges(implementingClass, conf)).setUseIsolatedScanners(InputConfigurator.isIsolated(implementingClass, conf)).setUseLocalIterators(InputConfigurator.usesLocalIterators(implementingClass, conf)).setOfflineScan(InputConfigurator.isOfflineScan(implementingClass, conf));
            return Maps.immutableEntry((Object)tableName, (Object)queryConfig);
        }
        return null;
    }

    public static Map<String, Map<KeyExtent, List<Range>>> binOffline(TableId tableId, List<Range> ranges, ClientContext context) throws AccumuloException, TableNotFoundException {
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        if (context.getTableState(tableId) != TableState.OFFLINE) {
            context.clearTableListCache();
            if (context.getTableState(tableId) != TableState.OFFLINE) {
                throw new AccumuloException("Table is online tableId:" + String.valueOf(tableId) + " cannot scan table in offline mode ");
            }
        }
        block0: for (Range range : ranges) {
            Text startRow = range.getStartKey() != null ? range.getStartKey().getRow() : new Text();
            Range metadataRange = new Range(new KeyExtent(tableId, startRow, null).toMetaRow(), true, null, false);
            Scanner scanner = context.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch(scanner);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
            scanner.setRange(metadataRange);
            RowIterator rowIter = new RowIterator(scanner);
            KeyExtent lastExtent = null;
            while (rowIter.hasNext()) {
                Object row = rowIter.next();
                String last = "";
                KeyExtent extent = null;
                String location = null;
                while (row.hasNext()) {
                    Map.Entry entry = (Map.Entry)row.next();
                    Key key = (Key)entry.getKey();
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME)) {
                        last = ((Value)entry.getValue()).toString();
                    }
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) || key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) {
                        location = ((Value)entry.getValue()).toString();
                    }
                    if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) continue;
                    extent = KeyExtent.fromMetaPrevRow(entry);
                }
                if (location != null) {
                    return null;
                }
                if (!extent.tableId().equals(tableId)) {
                    throw new AccumuloException("Saw unexpected table Id " + String.valueOf(tableId) + " " + String.valueOf(extent));
                }
                if (lastExtent != null && !extent.isPreviousExtent(lastExtent)) {
                    throw new AccumuloException(" " + String.valueOf(lastExtent) + " is not previous extent " + String.valueOf(extent));
                }
                binnedRanges.computeIfAbsent(last, k -> new HashMap()).computeIfAbsent(extent, k -> new ArrayList()).add(range);
                if (extent.endRow() == null || range.afterEndKey(new Key(extent.endRow()).followingKey(PartialKey.ROW))) continue block0;
                lastExtent = extent;
            }
        }
        return binnedRanges;
    }

    private static String toBase64(Writable writable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            writable.write((DataOutput)dos);
            dos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    private static <T extends Writable> T fromBase64(T writable, String enc) {
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(enc));
        DataInputStream dis = new DataInputStream(bais);
        try {
            writable.readFields((DataInput)dis);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writable;
    }

    public static void setSamplerConfiguration(Class<?> implementingClass, Configuration conf, SamplerConfiguration samplerConfig) {
        Objects.requireNonNull(samplerConfig);
        String key = InputConfigurator.enumToConfKey(implementingClass, ScanOpts.SAMPLER_CONFIG);
        String val = InputConfigurator.toBase64(new SamplerConfigurationImpl(samplerConfig));
        conf.set(key, val);
    }

    private static SamplerConfiguration getSamplerConfiguration(Class<?> implementingClass, Configuration conf) {
        String key = InputConfigurator.enumToConfKey(implementingClass, ScanOpts.SAMPLER_CONFIG);
        String encodedSC = conf.get(key);
        if (encodedSC == null) {
            return null;
        }
        return InputConfigurator.fromBase64(new SamplerConfigurationImpl(), encodedSC).toSamplerConfiguration();
    }

    public static enum ScanOpts {
        TABLE_NAME,
        AUTHORIZATIONS,
        RANGES,
        COLUMNS,
        ITERATORS,
        TABLE_CONFIGS,
        SAMPLER_CONFIG,
        CLASSLOADER_CONTEXT;

    }

    public static enum Features {
        AUTO_ADJUST_RANGES,
        SCAN_ISOLATION,
        USE_LOCAL_ITERATORS,
        SCAN_OFFLINE,
        BATCH_SCANNER,
        BATCH_SCANNER_THREADS;

    }
}

