/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.accumulo.core.client.lexicoder.Encoder;

public abstract class AbstractEncoder<T>
implements Encoder<T> {
    protected abstract T decodeUnchecked(byte[] var1, int var2, int var3) throws IllegalArgumentException;

    @Override
    public T decode(byte[] b) {
        Objects.requireNonNull(b, "cannot decode null byte array");
        return this.decodeUnchecked(b, 0, b.length);
    }

    public T decode(byte[] b, int offset, int len) {
        Objects.requireNonNull(b, "cannot decode null byte array");
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset %s cannot be negative", (int)offset);
        Preconditions.checkArgument((len >= 0 ? 1 : 0) != 0, (String)"length %s cannot be negative", (int)len);
        Preconditions.checkArgument((offset + len <= b.length ? 1 : 0) != 0, (String)"offset + length %s exceeds byte array length %s", (int)(offset + len), (int)b.length);
        return this.decodeUnchecked(b, offset, len);
    }
}

