/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.hadoop.io.Text;

public class CheckForMetadataProblems {
    private static boolean sawProblems = false;
    private static ServerUtilOpts opts;

    private static void checkTable(TableId tableId, TreeSet<KeyExtent> tablets) {
        String tableName;
        try {
            tableName = opts.getServerContext().getTableName(tableId);
        }
        catch (TableNotFoundException e) {
            tableName = null;
        }
        if (tablets.isEmpty()) {
            System.out.println("...No entries found in metadata table for table " + tableName + " (" + String.valueOf(tableId) + ")");
            sawProblems = true;
            return;
        }
        if (tablets.first().prevEndRow() != null) {
            System.out.println("...First entry for table " + tableName + " (" + String.valueOf(tableId) + ")  - " + String.valueOf(tablets.first()) + " - has non null prev end row");
            sawProblems = true;
            return;
        }
        if (tablets.last().endRow() != null) {
            System.out.println("...Last entry for table " + tableName + " (" + String.valueOf(tableId) + ") - " + String.valueOf(tablets.last()) + " - has non null end row");
            sawProblems = true;
            return;
        }
        Iterator<KeyExtent> tabIter = tablets.iterator();
        Text lastEndRow = tabIter.next().endRow();
        boolean everythingLooksGood = true;
        while (tabIter.hasNext()) {
            KeyExtent tabke = tabIter.next();
            boolean broke = false;
            if (tabke.prevEndRow() == null) {
                System.out.println("...Table " + tableName + " (" + String.valueOf(tableId) + ") has null prev end row in middle of table " + String.valueOf(tabke));
                broke = true;
            } else if (!tabke.prevEndRow().equals((Object)lastEndRow)) {
                System.out.println("...Table " + tableName + " (" + String.valueOf(tableId) + ") has a hole " + String.valueOf(tabke.prevEndRow()) + " != " + String.valueOf(lastEndRow));
                broke = true;
            }
            if (broke) {
                everythingLooksGood = false;
            }
            lastEndRow = tabke.endRow();
        }
        if (everythingLooksGood) {
            System.out.println("...All is well for table " + tableName + " (" + String.valueOf(tableId) + ")");
        } else {
            sawProblems = true;
        }
    }

    private static void checkMetadataAndRootTableEntries(String tableNameToCheck, ServerUtilOpts opts) throws Exception {
        TableId tableCheckId = opts.getServerContext().getTableId(tableNameToCheck);
        System.out.println("Checking tables whose metadata is found in: " + tableNameToCheck + " (" + String.valueOf(tableCheckId) + ")");
        HashMap<TableId, TreeSet> tables = new HashMap<TableId, TreeSet>();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();
             Scanner scanner = client.createScanner(tableNameToCheck, Authorizations.EMPTY);){
            scanner.setRange(MetadataSchema.TabletsSection.getRange());
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            Text colf = new Text();
            Text colq = new Text();
            boolean justLoc = false;
            int count = 0;
            for (Map.Entry entry : scanner) {
                colf = ((Key)entry.getKey()).getColumnFamily(colf);
                colq = ((Key)entry.getKey()).getColumnQualifier(colq);
                ++count;
                TableId tableId = KeyExtent.fromMetaRow((Text)((Key)entry.getKey()).getRow()).tableId();
                TreeSet<KeyExtent> tablets = (TreeSet<KeyExtent>)tables.get(tableId);
                if (tablets == null) {
                    tables.forEach(CheckForMetadataProblems::checkTable);
                    tables.clear();
                    tablets = new TreeSet<KeyExtent>();
                    tables.put(tableId, tablets);
                }
                if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.equals(colf, colq)) {
                    KeyExtent tabletKe = KeyExtent.fromMetaPrevRow((Map.Entry)entry);
                    tablets.add(tabletKe);
                    justLoc = false;
                    continue;
                }
                if (!colf.equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) continue;
                if (justLoc) {
                    System.out.println("Problem at key " + String.valueOf(entry.getKey()));
                    sawProblems = true;
                }
                justLoc = true;
            }
            if (count == 0) {
                System.err.println("ERROR : table " + tableNameToCheck + " (" + String.valueOf(tableCheckId) + ") is empty");
                sawProblems = true;
            }
        }
        tables.forEach(CheckForMetadataProblems::checkTable);
        if (!sawProblems) {
            System.out.println("No problems found in " + tableNameToCheck + " (" + String.valueOf(tableCheckId) + ")");
        }
    }

    public static void main(String[] args) throws Exception {
        opts = new ServerUtilOpts();
        opts.parseArgs(CheckForMetadataProblems.class.getName(), args, new Object[0]);
        Span span = TraceUtil.startSpan(CheckForMetadataProblems.class, (String)"main");
        try (Scope scope = span.makeCurrent();){
            CheckForMetadataProblems.checkMetadataAndRootTableEntries(RootTable.NAME, opts);
            System.out.println();
            CheckForMetadataProblems.checkMetadataAndRootTableEntries(MetadataTable.NAME, opts);
            if (sawProblems) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span.end();
        }
    }
}

