/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.server.master.balancer.GroupBalancer;
import org.apache.hadoop.io.Text;

@Deprecated(since="2.1.0")
public class RegexGroupBalancer
extends GroupBalancer {
    public static final String REGEX_PROPERTY = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "balancer.group.regex.pattern";
    public static final String DEFAUT_GROUP_PROPERTY = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "balancer.group.regex.default";
    public static final String WAIT_TIME_PROPERTY = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "balancer.group.regex.wait.time";
    private final TableId tableId;

    public RegexGroupBalancer(TableId tableId) {
        super(tableId);
        this.tableId = tableId;
    }

    @Override
    protected long getWaitTime() {
        Map customProps = this.context.getTableConfiguration(this.tableId).getAllPropertiesWithPrefix(Property.TABLE_ARBITRARY_PROP_PREFIX);
        if (customProps.containsKey(WAIT_TIME_PROPERTY)) {
            return ConfigurationTypeHelper.getTimeInMillis((String)((String)customProps.get(WAIT_TIME_PROPERTY)));
        }
        return super.getWaitTime();
    }

    @Override
    protected Function<KeyExtent, String> getPartitioner() {
        Map customProps = this.context.getTableConfiguration(this.tableId).getAllPropertiesWithPrefix(Property.TABLE_ARBITRARY_PROP_PREFIX);
        String regex = (String)customProps.get(REGEX_PROPERTY);
        final String defaultGroup = (String)customProps.get(DEFAUT_GROUP_PROPERTY);
        final Pattern pattern = Pattern.compile(regex);
        return new Function<KeyExtent, String>(){

            @Override
            public String apply(KeyExtent input) {
                Text er = input.endRow();
                if (er == null) {
                    return defaultGroup;
                }
                Matcher matcher = pattern.matcher(er.toString());
                if (matcher.matches() && matcher.groupCount() == 1) {
                    return matcher.group(1);
                }
                return defaultGroup;
            }
        };
    }
}

