/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.process.thrift.ServerProcessService;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.AccumuloDataVersion;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.metrics.ProcessMetrics;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
implements AutoCloseable,
MetricsProducer,
Runnable,
ServerProcessService.Iface {
    private final ServerContext context;
    protected final String applicationName;
    private HostAndPort advertiseAddress;
    private final String bindAddress;
    private final Logger log;
    private final ProcessMetrics processMetrics;
    protected final long idleReportingPeriodNanos;
    private volatile long idlePeriodStartNanos = 0L;
    private volatile Thread serverThread;
    private volatile Thread verificationThread;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final AtomicBoolean shutdownComplete = new AtomicBoolean(false);

    protected AbstractServer(String appName, ServerOpts opts, String[] args) {
        this.log = LoggerFactory.getLogger((String)this.getClass().getName());
        this.applicationName = appName;
        opts.parseArgs(appName, args, new Object[0]);
        SiteConfiguration siteConfig = opts.getSiteConfiguration();
        boolean oldBindParameterSpecifiedOnCmdLine = false;
        boolean newBindParameterSpecified = false;
        for (String arg : args) {
            if (arg.equals("-a") || arg.equals("--address")) {
                oldBindParameterSpecifiedOnCmdLine = true;
                continue;
            }
            if (!siteConfig.isPropertySet(Property.RPC_PROCESS_BIND_ADDRESS)) continue;
            newBindParameterSpecified = true;
        }
        if (oldBindParameterSpecifiedOnCmdLine && newBindParameterSpecified) {
            throw new IllegalStateException("Argument '-a' cannot be used with property 'rpc.bind.addr'");
        }
        String newBindParameter = siteConfig.get(Property.RPC_PROCESS_BIND_ADDRESS);
        this.bindAddress = newBindParameterSpecified || !newBindParameter.equals(Property.RPC_PROCESS_BIND_ADDRESS.getDefaultValue()) ? newBindParameter : (oldBindParameterSpecifiedOnCmdLine ? opts.getAddress() : "0.0.0.0");
        String advertAddr = siteConfig.get(Property.RPC_PROCESS_ADVERTISE_ADDRESS);
        if (advertAddr != null && !advertAddr.isBlank()) {
            HostAndPort advertHP = HostAndPort.fromString((String)advertAddr);
            if (advertHP.getHost().equals("0.0.0.0")) {
                throw new IllegalArgumentException("Advertise address cannot be 0.0.0.0");
            }
            this.advertiseAddress = advertHP;
        } else {
            this.advertiseAddress = null;
        }
        this.log.info("Bind address: {}, advertise address: {}", (Object)this.bindAddress, (Object)this.advertiseAddress);
        SecurityUtil.serverLogin((AccumuloConfiguration)siteConfig);
        this.context = new ServerContext(siteConfig);
        String upgradePrepNode = this.context.getZooKeeperRoot() + "/upgrade_ready";
        try {
            if (this.context.getZooReader().exists(upgradePrepNode)) {
                throw new IllegalStateException("Instance has been prepared for upgrade to a minor or major version greater than 2.1.4, no servers can be started. To undo this state and abort upgrade preparations delete the zookeeper node: " + upgradePrepNode);
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException("Error checking for upgrade preparation node (" + upgradePrepNode + ") in zookeeper", e);
        }
        this.log.info("Version 2.1.4");
        this.log.info("Instance " + String.valueOf(this.context.getInstanceID()));
        this.context.init(appName);
        ClassLoaderUtil.initContextFactory((AccumuloConfiguration)this.context.getConfiguration());
        TraceUtil.setProcessTracing((boolean)this.context.getConfiguration().getBoolean(Property.GENERAL_OPENTELEMETRY_ENABLED));
        if (this.context.getSaslParams() != null) {
            this.context.enforceKerberosLogin();
        }
        this.processMetrics = new ProcessMetrics();
        this.idleReportingPeriodNanos = TimeUnit.MILLISECONDS.toNanos(this.context.getConfiguration().getTimeInMillis(Property.GENERAL_IDLE_PROCESS_INTERVAL));
    }

    protected void updateIdleStatus(boolean isIdle) {
        boolean hasExceededIdlePeriod;
        boolean shouldResetIdlePeriod = !isIdle || this.idleReportingPeriodNanos == 0L;
        boolean isIdlePeriodNotStarted = this.idlePeriodStartNanos == 0L;
        boolean bl = hasExceededIdlePeriod = System.nanoTime() - this.idlePeriodStartNanos > this.idleReportingPeriodNanos;
        if (shouldResetIdlePeriod) {
            this.idlePeriodStartNanos = 0L;
            this.processMetrics.setIdleValue(false);
        } else if (isIdlePeriodNotStarted) {
            this.idlePeriodStartNanos = System.nanoTime();
        } else if (hasExceededIdlePeriod) {
            this.processMetrics.setIdleValue(true);
            this.idlePeriodStartNanos = 0L;
        }
    }

    public void gracefulShutdown(TCredentials credentials) {
        try {
            if (!this.context.getSecurityOperation().canPerformSystemActions(credentials)) {
                this.log.warn("Ignoring shutdown request, user " + credentials.getPrincipal() + " does not have the appropriate permissions.");
            }
        }
        catch (ThriftSecurityException e) {
            this.log.error("Error trying to determine if user has permissions to shutdown server, ignoring request", (Throwable)e);
            return;
        }
        if (this.shutdownRequested.compareAndSet(false, true)) {
            this.log.info("Graceful shutdown initiated.");
        } else {
            this.log.warn("Graceful shutdown previously requested.");
        }
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequested.get();
    }

    public AtomicBoolean getShutdownComplete() {
        return this.shutdownComplete;
    }

    public void runServer() throws Exception {
        AtomicReference err = new AtomicReference();
        this.serverThread = new Thread(TraceUtil.wrap((Runnable)this), this.applicationName);
        this.serverThread.setUncaughtExceptionHandler((thread, exception) -> err.set(exception));
        this.serverThread.start();
        this.serverThread.join();
        if (this.verificationThread != null) {
            this.verificationThread.interrupt();
            this.verificationThread.join();
        }
        this.log.info(this.getClass().getSimpleName() + " process shut down.");
        Throwable thrown = (Throwable)err.get();
        if (thrown != null) {
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
            if (thrown instanceof Exception) {
                throw (Exception)thrown;
            }
            throw new RuntimeException("Weird throwable type thrown", thrown);
        }
    }

    public void registerMetrics(MeterRegistry registry) {
        if (this.processMetrics != null) {
            this.processMetrics.registerMetrics(registry);
        }
    }

    public HostAndPort getAdvertiseAddress() {
        return this.advertiseAddress;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    protected void updateAdvertiseAddress(HostAndPort thriftBindAddress) {
        if (this.advertiseAddress == null) {
            this.advertiseAddress = thriftBindAddress;
        } else if (!this.advertiseAddress.hasPort()) {
            this.advertiseAddress = HostAndPort.fromParts((String)this.advertiseAddress.getHost(), (int)thriftBindAddress.getPort());
        }
    }

    public ServerContext getContext() {
        return this.context;
    }

    public AccumuloConfiguration getConfiguration() {
        return this.getContext().getConfiguration();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public abstract ServiceLock getLock();

    public void startServiceLockVerificationThread() {
        Preconditions.checkState((this.verificationThread == null ? 1 : 0) != 0, (Object)"verification thread not null, startServiceLockVerificationThread likely called twice");
        Preconditions.checkState((this.serverThread != null ? 1 : 0) != 0, (Object)"server thread is null, no server process is running");
        long interval = this.getConfiguration().getTimeInMillis(Property.GENERAL_SERVER_LOCK_VERIFICATION_INTERVAL);
        if (interval > 0L) {
            this.verificationThread = Threads.createCriticalThread((String)"service-lock-verification-thread", (OptionalInt)OptionalInt.of(6), () -> {
                while (this.serverThread.isAlive()) {
                    ServiceLock lock = this.getLock();
                    try {
                        this.log.trace("ServiceLockVerificationThread - checking ServiceLock existence in ZooKeeper");
                        if (lock != null && !lock.verifyLockAtSource()) {
                            Halt.halt((int)-1, (String)"Lock verification thread could not find lock");
                        }
                        this.log.trace("ServiceLockVerificationThread - ServiceLock exists in ZooKeeper, sleeping for {}ms", (Object)interval);
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException e) {
                        if (!this.serverThread.isAlive()) continue;
                        throw new Error("Sleep interrupted in ServiceLock verification thread");
                    }
                }
            });
            this.verificationThread.start();
        } else {
            this.log.info("ServiceLockVerificationThread not started as " + Property.GENERAL_SERVER_LOCK_VERIFICATION_INTERVAL.getKey() + " is zero");
        }
    }

    @Override
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    protected void waitForUpgrade() throws InterruptedException {
        while (AccumuloDataVersion.getCurrentVersion(this.getContext()) < AccumuloDataVersion.get()) {
            LOG.info("Waiting for upgrade to complete.");
            Thread.sleep(1000L);
        }
    }
}

