/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteZooInstance {
    private static final Logger log = LoggerFactory.getLogger(DeleteZooInstance.class);

    public static void execute(ServerContext context, boolean clean, String instance, String auth) throws InterruptedException, KeeperException {
        ZooReaderWriter zk = context.getZooReaderWriter();
        if (auth != null) {
            ZooUtil.digestAuth((ZooKeeper)zk.getZooKeeper(), (String)auth);
        }
        if (clean) {
            if (instance != null) {
                throw new IllegalArgumentException("Cannot set clean flag to true and also an instance name");
            }
            DeleteZooInstance.cleanAllOld(context, zk);
        } else {
            Objects.requireNonNull(instance, "Instance name must not be null");
            DeleteZooInstance.removeInstance(context, zk, instance);
        }
    }

    private static void removeInstance(ServerContext context, ZooReaderWriter zk, String instance) throws InterruptedException, KeeperException {
        HashSet<String> instances = new HashSet<String>(DeleteZooInstance.getInstances(zk));
        HashSet uuids = new HashSet(zk.getChildren("/accumulo"));
        uuids.remove("instances");
        if (instances.contains(instance)) {
            String instanceId;
            String path = DeleteZooInstance.getInstancePath(instance);
            byte[] data = zk.getData(path);
            if (data != null && DeleteZooInstance.checkCurrentInstance(context, instance, instanceId = new String(data, StandardCharsets.UTF_8))) {
                DeleteZooInstance.deleteRetry(zk, path);
                DeleteZooInstance.deleteRetry(zk, DeleteZooInstance.getRootChildPath(instanceId));
                System.out.println("Deleted instance: " + instance);
            }
        } else if (uuids.contains(instance)) {
            for (String zkInstance : instances) {
                String instanceId;
                String path = DeleteZooInstance.getInstancePath(zkInstance);
                byte[] data = zk.getData(path);
                if (data == null || !instance.equals(instanceId = new String(data, StandardCharsets.UTF_8)) || !DeleteZooInstance.checkCurrentInstance(context, instance, instanceId)) continue;
                DeleteZooInstance.deleteRetry(zk, path);
                System.out.println("Deleted instance: " + instance);
            }
            DeleteZooInstance.deleteRetry(zk, DeleteZooInstance.getRootChildPath(instance));
        }
    }

    private static void cleanAllOld(ServerContext context, ZooReaderWriter zk) throws InterruptedException, KeeperException {
        for (String child : zk.getChildren("/accumulo")) {
            if ("/instances".equals("/" + child)) {
                for (String instanceName : DeleteZooInstance.getInstances(zk)) {
                    String instanceNamePath = DeleteZooInstance.getInstancePath(instanceName);
                    byte[] id = zk.getData(instanceNamePath);
                    if (id == null || new String(id, StandardCharsets.UTF_8).equals(context.getInstanceID().canonical())) continue;
                    DeleteZooInstance.deleteRetry(zk, instanceNamePath);
                    System.out.println("Deleted instance: " + instanceName);
                }
                continue;
            }
            if (child.equals(context.getInstanceID().canonical())) continue;
            DeleteZooInstance.deleteRetry(zk, DeleteZooInstance.getRootChildPath(child));
        }
    }

    private static boolean checkCurrentInstance(ServerContext context, String instanceName, String instanceId) {
        boolean operate = true;
        if (instanceId.equals(context.getInstanceID().canonical())) {
            String line = String.valueOf(System.console().readLine("Warning: This is the current instance, are you sure? (yes|no): ", new Object[0]));
            boolean bl = operate = line != null && (line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes"));
            if (!operate) {
                System.out.println("Instance deletion of '" + instanceName + "' cancelled.");
            }
        }
        return operate;
    }

    private static String getRootChildPath(String child) {
        return "/accumulo/" + child;
    }

    private static String getInstancePath(String instanceName) {
        return "/accumulo/instances/" + instanceName;
    }

    private static List<String> getInstances(ZooReaderWriter zk) throws InterruptedException, KeeperException {
        return zk.getChildren("/accumulo/instances");
    }

    private static void deleteRetry(ZooReaderWriter zk, String path) throws InterruptedException, KeeperException {
        for (int i = 0; i < 10; ++i) {
            try {
                zk.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
                return;
            }
            catch (KeeperException.NotEmptyException ex) {
                if (!log.isDebugEnabled()) continue;
                log.debug(ex.getMessage(), (Throwable)ex);
                continue;
            }
        }
    }
}

